//////////////////////////////////////////////
// Buffer.js
//
//////////////////////////////////////////////

/// Class ------------------------------------
	
nkGraphicsTests.RenderContext = class RenderContext extends nkDebug.TestClass
{
	static instance = new RenderContext ("nkGraphicsTests.RenderContext") ;

	nkTests =
	{
		__testInit__ : function ()
		{
			// Init nkGraphics
			const s = nkGraphics.System.getInstance() ;

			const initResult = s.initialize() ;

			if (!initResult)
				console.log("Failure to initialize nkGraphics, bypassing Buffer test...") ;

			return initResult ;
		},
		__testShutdown__ : function ()
		{
			nkGraphics.System.getInstance().shutdown()  ;
			nkGraphics.System.kill() ;
		},

		testOffscreenRenderContextGammaCorrectionUpdate : function ()
		{
			// Prepare the compositor
			const compositor = nkGraphics.CompositorManager.getInstance().createOrRetrieve("Test") ;
			const node = compositor.addNode() ;
			const op = node.addOperations() ;

			op.setToBackBuffer(true) ;

			const pass = op.addClearTargetsPass() ;
			pass.setClearColor(new nkMaths.Vector (0.5, 0.5, 0.5, 1.0)) ;

			// Prepare the context
			const contextDescriptor = new nkGraphics.RenderContextDescriptor (16, 16, true) ;
			const context = nkGraphics.RenderContextManager.getInstance().createRenderContext(contextDescriptor) ;
			context.setCompositor(compositor) ;

			// Ensure gamma correction is on
			context.setGammaCorrected(true) ;

			// Request rendering
			nkGraphics.System.getInstance().frame(context) ;

			// Check image content
			const imageGamma = context.getBackBuffer().convertToImage(0, 0) ;
			nkWebUnitTests.ImageHandlingUtils.checkPixel(imageGamma, new nkMaths.Vector (188, 188, 188, 255), 0, 0) ;
			imageGamma.delete() ;

			// Switch correction
			context.setGammaCorrected(false) ;
			nkGraphics.System.getInstance().frame(context) ;
			
			const imageNoGamma = context.getBackBuffer().convertToImage(0, 0) ;
			nkWebUnitTests.ImageHandlingUtils.checkPixel(imageNoGamma, new nkMaths.Vector (127, 127, 127, 255), 0, 0) ;
			imageNoGamma.delete() ;
		},

	}
}